/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.more_bows_and_arrows.core.util;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class FireworkUtil {
    public static void createRandomFireworkFromEntity(@NotNull LivingEntity owner, BlockPos blockPos) {
        Level level = owner.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ItemStack fireworkRocketItem = Items.FIREWORK_ROCKET.getDefaultInstance();
        fireworkRocketItem = FireworkUtil.addRandomFireworkData(serverLevel.getRandom(), fireworkRocketItem);
        FireworkUtil.spawnFireworkEntity((Level)serverLevel, owner, blockPos, fireworkRocketItem);
    }

    private static void spawnFireworkEntity(Level level, LivingEntity owner, BlockPos pos, ItemStack fireworkItem) {
        FireworkRocketEntity fireworkRocketEntity = new FireworkRocketEntity(owner.level(), (Entity)owner, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), fireworkItem);
        fireworkRocketEntity.moveTo((double)pos.getX(), (double)pos.getY() + 1.0, (double)pos.getZ());
        level.addFreshEntity((Entity)fireworkRocketEntity);
    }

    private static boolean noFireworkExplosionSet(ItemStack stack) {
        if (stack.get(DataComponents.FIREWORKS) == null || stack.getComponents().isEmpty()) {
            return false;
        }
        return !stack.getComponents().has(DataComponents.FIREWORKS) || !((Fireworks)stack.get(DataComponents.FIREWORKS)).explosions().isEmpty();
    }

    private static ItemStack addRandomFireworkData(RandomSource random, ItemStack stack) {
        ItemStack newRandomFireworkItemStack = stack.copy();
        if (FireworkUtil.noFireworkExplosionSet(stack)) {
            ArrayList<FireworkExplosion> explosions = new ArrayList<FireworkExplosion>();
            FireworkExplosion hardCoded = new FireworkExplosion(FireworkExplosion.Shape.BURST, IntList.of((int)0), IntList.of((int)0), true, true);
            explosions.add(hardCoded);
            Fireworks fireworks = new Fireworks(1, explosions);
            ItemStack fireworkRocketItem = Items.FIREWORK_ROCKET.getDefaultInstance();
            fireworkRocketItem.set(DataComponents.FIREWORKS, (Object)fireworks);
        }
        return newRandomFireworkItemStack;
    }

    private static ListTag randomExplosions(RandomSource random) {
        ListTag list = new ListTag();
        list.add((Object)FireworkUtil.randomExplosion(random));
        if (random.nextBoolean()) {
            for (int i = 0; i < random.nextInt(2) + 1; ++i) {
                list.add((Object)FireworkUtil.randomExplosion(random));
            }
        }
        return list;
    }

    private static CompoundTag randomExplosion(RandomSource random) {
        CompoundTag EXPLOSION = new CompoundTag();
        EXPLOSION.putIntArray("Colors", FireworkUtil.randomColors(random, 1));
        EXPLOSION.putIntArray("FadeColors", FireworkUtil.randomColors(random, 5));
        EXPLOSION.putByte("Type", (byte)random.nextInt(5));
        int randomFlickerTrail = random.nextInt(10);
        if (randomFlickerTrail == 7 || randomFlickerTrail == 9) {
            EXPLOSION.putBoolean("Trail", true);
        }
        if (randomFlickerTrail == 8 || randomFlickerTrail == 9) {
            EXPLOSION.putBoolean("Flicker", true);
        }
        return EXPLOSION;
    }

    private static ArrayList<Integer> randomColors(RandomSource random, int probChance) {
        ArrayList<Integer> RANDOM_COLORS = new ArrayList<Integer>();
        RANDOM_COLORS.add(FireworkUtil.randomColor(random));
        for (int i = 0; i < random.nextInt(3); ++i) {
            RANDOM_COLORS.add(FireworkUtil.randomColor(random));
        }
        return RANDOM_COLORS;
    }

    private static int randomColor(RandomSource random) {
        DyeColor DEFAULTED_COLOR = DyeColor.WHITE;
        String[] blockedColors = new String[]{DyeColor.BLACK.getName(), DyeColor.GRAY.getName(), DyeColor.LIGHT_GRAY.getName(), DyeColor.WHITE.getName()};
        DyeColor chosenColor = DyeColor.byId((int)random.nextInt(DyeColor.values().length));
        Set skippedIDSet = Arrays.stream(blockedColors).map(colorName -> DyeColor.byName((String)colorName, (DyeColor)DEFAULTED_COLOR).getId()).collect(Collectors.toSet());
        while (skippedIDSet.contains(chosenColor.getId())) {
            chosenColor = DyeColor.byId((int)random.nextInt(DyeColor.values().length));
        }
        return chosenColor.getFireworkColor();
    }
}

